<x-app-layout>
<div class="bg-gray-100 dark:bg-gray-900 py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-7xl mx-auto">
        <h2 class="text-3xl font-bold text-center text-red-800 dark:text-red-400 mb-10">Travel & Accommodation</h2>

        <p class="text-center text-gray-700 dark:text-gray-300 mb-12 max-w-2xl mx-auto">
            Find your ideal stay at the Engineers Convention with a range of accommodation options. Choose from luxury hotels, business-class comfort, or budget-friendly choices to suit your preferences.
        </p>

        <div class="grid gap-6 sm:grid-cols-1 md:grid-cols-2 lg:grid-cols-3">
            @php
                $hotels = [
                    [
                        'name' => 'Prideinn Paradise Beach Resort & Spa (Host Venue)',
                        'image' => 'prideinn-paradise.jpg',
                        'rates' => [
                            'Ksh. 16,500/= per night (BB)',
                            'Ksh. 17,000/= per night (Half Board)',
                        ],
                        'phone' => '+254 723 634 669',
                        'email' => 'dsm@prideinnparadise.com',
                    ],
                    [
                        'name' => 'Prideinn Flamingo Beach & Spa',
                        'image' => 'prideinn-flamingo.jpg',
                        'rates' => [
                            'Ksh. 16,000/= per night (Half Board)',
                            'Ksh. 15,500/= per night (BB)',
                        ],
                        'phone' => '+254 723 634 669',
                        'email' => 'dsm@prideinnflamingo.com',
                    ],
                    [
                        'name' => 'Travellers Beach Hotel and Club',
                        'image' => 'travellers-beach.jpg',
                        'rates' => [
                            'Ksh. 14,000/= per night (Half Board)',
                            'Ksh. 13,000/= per night (BB)',
                        ],
                        'phone' => '+254 720 566 626',
                        'email' => 'nambalu.evalyn@travellershtl.com',
                    ],
                    [
                        'name' => 'Sarova Whitesands Beach Hotel',
                        'image' => 'sarova-whitesands.jpg',
                        'rates' => [
                            'Ksh. 20,000/= Garden View (Half Board)',
                            'Ksh. 25,000/= Sea Front (Half Board)',
                        ],
                        'phone' => '+254 722 852 001',
                        'email' => 'vera.moraa@sarovahotels.com',
                    ],
                    [
                        'name' => 'Sunset Paradise Holiday Homes',
                        'image' => 'sunset-paradise.jpg',
                        'rates' => [
                            'Ksh. 4,850 Bed Only',
                            'Ksh. 7,100 Half Board',
                        ],
                        'phone' => '+254 727 763 812',
                        'email' => 'sunsettmarketing00@gmail.com',
                    ],
                    [
                        'name' => 'Neptune Beach Resort',
                        'image' => 'neptune-beach.jpg',
                        'rates' => [
                            'Ksh. 14,850/= Single (BB)',
                            'Ksh. 22,000/= Twin (BB)',
                        ],
                        'phone' => '+254 734 346 942',
                        'email' => 'sales2@neptunehotels.com',
                    ],
                    [
                        'name' => 'Serena Beach Resort & Spa',
                        'image' => 'serena-beach.jpg',
                        'rates' => [
                            'Ksh. 21,150/= Single (Half Board)',
                            'Ksh. 25,000/= Twin (BB)',
                        ],
                        'phone' => '+254 734 699 853',
                        'email' => 'reservations.mombasa@serenahotels.com',
                    ],
                ];
            @endphp

            @foreach ($hotels as $hotel)
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden flex flex-col">
                <!-- Hotel Image -->
                <img src="{{ asset('images/' . $hotel['image']) }}" alt="{{ $hotel['name'] }}" class="w-full h-48 object-cover">

                <!-- Card Body -->
                <div class="p-5 flex flex-col justify-between flex-grow">
                    <div>
                        <h3 class="text-xl font-semibold text-red-800 dark:text-red-400 mb-2">{{ $hotel['name'] }}</h3>
                        <ul class="text-gray-700 dark:text-gray-300 text-sm mb-4 list-disc list-inside">
                            @foreach ($hotel['rates'] as $rate)
                                <li>{{ $rate }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>

                <!-- Card Footer with Contact Info -->
                <div class="bg-red-100 dark:bg-gray-700 px-4 py-3 text-sm text-center text-gray-800 dark:text-gray-200">
                    <p class="flex  gap-2 mb-1">
                        <i class="fas fa-phone-alt text-red-700 dark:text-red-400"></i>
                        <a href="tel:{{ $hotel['phone'] }}" class="hover:underline">{{ $hotel['phone'] }}</a>
                    </p>
                    <p class="flex gap-2">
                        <i class="fas fa-envelope text-red-700 dark:text-red-400"></i>
                        <a href="mailto:{{ $hotel['email'] }}" class="text-blue-600 dark:text-blue-300 underline break-all">
                            {{ $hotel['email'] }}
                        </a>
                    </p>
                </div>
            </div>

            @endforeach
        </div>
    </div>
</div>
</x-app-layout>
