<!-- Beach-themed footer -->
<footer class="footer-container text-white relative overflow-hidden">
    <!-- Waves animation -->
    <div class="wave"></div>
    
    <!-- Palm trees -->
    <img src="https://www.freeiconspng.com/uploads/palm-tree-png-21.png" alt="Palm Tree" class="palm-tree hidden md:block">
    <img src="https://www.freeiconspng.com/uploads/palm-tree-png-21.png" alt="Palm Tree" class="palm-tree-2 hidden md:block">
    
    <!-- Shell decorations -->
    <img src="https://www.freeiconspng.com/uploads/seashell-png-30.png" alt="Shell" class="shell hidden md:block">
    <img src="https://www.freeiconspng.com/uploads/seashell-png-5.png" alt="Shell" class="shell-2 hidden md:block">
    
    <!-- Footer content -->
    <div class="container mx-auto px-6 py-16 relative z-10">
        <div class="flex flex-col md:flex-row justify-between">
            <!-- Company info -->
            <div class="w-full md:w-1/3 mb-8 md:mb-0">
                <h3 class="text-xl font-bold mb-4 flex items-center">
                    <!-- <i class="fas fa-umbrella-beach mr-2"></i> -->
                    The Institution of Engineers of Kenya
                </h3>
                <p class="mb-4 text-blue-100">A leading Voice in Engineering.</p>
                <div class="flex space-x-4">
                    <a href="#" class="text-white hover:text-yellow-300 transition">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="text-white hover:text-yellow-300 transition">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="text-white hover:text-yellow-300 transition">
                        <i class="fab fa-instagram"></i>
                    </a>
                    <a href="#" class="text-white hover:text-yellow-300 transition">
                        <i class="fab fa-pinterest"></i>
                    </a>
                </div>
            </div>
            
            <!-- Quick links -->
            <div class="w-full md:w-1/3 mb-8 md:mb-0">
                <h4 class="text-xl font-semibold mb-4 border-b-2 border-yellow-400 pb-2 inline-block">Explore</h4>
                <ul class="space-y-2">
                    <li><a href="#" class="hover:text-yellow-300 transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i> Home</a></li>
                    <li><a href="#" class="hover:text-yellow-300 transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i> Beaches</a></li>
                    <li><a href="#" class="hover:text-yellow-300 transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i> Resorts</a></li>
                    <li><a href="#" class="hover:text-yellow-300 transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i> Activities</a></li>
                    <li><a href="#" class="hover:text-yellow-300 transition flex items-center"><i class="fas fa-chevron-right mr-2 text-xs"></i> Gallery</a></li>
                </ul>
            </div>
            
            <!-- Contact info -->
            <div class="w-full md:w-1/3 mb-8 md:mb-0">
                <h4 class="text-xl font-semibold mb-4 border-b-2 border-yellow-400 pb-2 inline-block">Contact Us</h4>
                <ul class="space-y-3">
                    <li class="flex items-start">
                        <i class="fas fa-map-marker-alt mt-1 mr-3 text-yellow-400"></i>
                        <span>1st Floor, Top Plaza, Kindaruma Road</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-phone-alt mt-1 mr-3 text-yellow-400"></i>
                        <span>+1 (555) 123-4567</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-envelope mt-1 mr-3 text-yellow-400"></i>
                        <span>convention@iekenya.org</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-clock mt-1 mr-3 text-yellow-400"></i>
                        <span>24/7 Customer Support</span>
                    </li>
                </ul>
            </div>
        </div>
        
        <!-- Copyright -->
        <div class="border-t border-blue-300 mt-12 pt-6 text-center">
            <p class="text-blue-100">
                &copy; 2025 The Institution of Engineers of Kenya. All Rights Reserved.  
                <!-- <a href="#" class="hover:text-yellow-300 transition">3</a> |  -->
                <!-- <a href="#" class="hover:text-yellow-300 transition">Terms of Service</a> -->
            </p>
        </div>
    </div>
    
    <!-- Floating elements decoration -->
    <div class="absolute bottom-10 left-1/4 w-8 h-8 bg-white rounded-full opacity-10 animate-float-1"></div>
    <div class="absolute bottom-20 right-1/3 w-6 h-6 bg-white rounded-full opacity-15 animate-float-2"></div>
    <div class="absolute bottom-30 left-2/3 w-4 h-4 bg-white rounded-full opacity-20 animate-float-3"></div>
</footer>

<script>
        // Add floating animation to bubbles
        document.addEventListener('DOMContentLoaded', function() {
            const bubbles = document.querySelectorAll('[class*="animate-float"]');
            
            bubbles.forEach((bubble, index) => {
                // Set random positions
                bubble.style.left = `${Math.random() * 80 + 10}%`;
                bubble.style.bottom = `${Math.random() * 30}px`;
                
                // Create animation
                const duration = 5 + Math.random() * 10;
                const delay = Math.random() * 5;
                const distance = 20 + Math.random() * 50;
                
                bubble.style.animation = `float ${duration}s ease-in-out ${delay}s infinite alternate`;
                
                // Add keyframes
                const style = document.createElement('style');
                style.innerHTML = `
                    @keyframes float {
                        0% { transform: translateY(0) scale(1); opacity: ${0.05 + Math.random() * 0.1}; }
                        50% { transform: translateY(-${distance}px) scale(${1 + Math.random() * 0.2}); opacity: ${0.1 + Math.random() * 0.1}; }
                        100% { transform: translateY(0) scale(1); opacity: ${0.05 + Math.random() * 0.1}; }
                    }
                `;
                document.head.appendChild(style);
            });
        });
    </script>

