<!-- Top Navigation -->
<div class="top-nav-bar bg-red-800 dark:bg-gray-800 text-sm text-amber-200 dark:text-gray-300">
  <div class="max-w-screen-xl mx-auto flex justify-between items-center px-4 py-2">
    <div>
      <span> <i class="fa-solid fa-phone-volume"></i> +254 721 729 363</span>
      <span class="ml-4"> <i class="fa-solid fa-envelope"></i> convention@iekenya.org</span>
    </div>
    <div class="space-x-4">
      <div class="flex space-x-4 text-amber-400 dark:text-gray-300">
        <!-- X (Twitter) -->
        <a href="https://x.com/TheIEK" class="hover:text-black" aria-label="X / Twitter">
          <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" class="w-5 h-5" fill="currentColor" viewBox="0 0 50 50">
            <path d="M 11 4 C 7.134 4 4 7.134 4 11 L 4 39 C 4 42.866 7.134 46 11 46 L 39 46 C 42.866 46 46 42.866 46 39 L 46 11 C 46 7.134 42.866 4 39 4 L 11 4 z M 13.085938 13 L 21.023438 13 L 26.660156 21.009766 L 33.5 13 L 36 13 L 27.789062 22.613281 L 37.914062 37 L 29.978516 37 L 23.4375 27.707031 L 15.5 37 L 13 37 L 22.308594 26.103516 L 13.085938 13 z M 16.914062 15 L 31.021484 35 L 34.085938 35 L 19.978516 15 L 16.914062 15 z"></path>
          </svg>
        </a>

        <!-- Facebook -->
        <a href="https://www.facebook.com/TheIEK/" class="hover:text-blue-600" aria-label="Facebook">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
            <path d="M22 12c0-5.522-4.477-10-10-10S2 6.478 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54v-2.89h2.54V9.845c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.261c-1.243 0-1.63.772-1.63 1.562v1.875h2.773l-.443 2.89h-2.33v6.987C18.343 21.128 22 16.991 22 12z"/>
          </svg>
        </a>

        <!-- Instagram -->
        <a href="https://www.instagram.com/theiekenya/?hl=en" class="hover:text-pink-500" aria-label="Instagram">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
            <path d="M7.5 2C4.462 2 2 4.462 2 7.5v9C2 19.538 4.462 22 7.5 22h9c3.038 0 5.5-2.462 5.5-5.5v-9C22 4.462 19.538 2 16.5 2h-9zM20 7.5V16.5c0 1.932-1.568 3.5-3.5 3.5h-9A3.504 3.504 0 0 1 4 16.5v-9C4 5.568 5.568 4 7.5 4h9A3.504 3.504 0 0 1 20 7.5zM12 7a5 5 0 1 0 .001 10.001A5 5 0 0 0 12 7zm0 8a3 3 0 1 1 0-6 3 3 0 0 1 0 6zm4.5-8.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"/>
          </svg>
        </a>

        <!-- LinkedIn - Alternate Design -->
        <a href="https://ke.linkedin.com/company/the-institution-of-engineers-of-kenya" class="hover:text-blue-600" aria-label="LinkedIn">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
            <path d="M19 0h-14C2.24 0 0 2.24 0 5v14c0 2.76 2.24 5 5 5h14c2.76 0 5-2.24 5-5V5c0-2.76-2.24-5-5-5zM7.12 20H3.56V9h3.56v11zM5.34 7.53c-1.14 0-2.06-.93-2.06-2.08 0-1.15.92-2.08 2.06-2.08 1.14 0 2.06.93 2.06 2.08 0 1.15-.92 2.08-2.06 2.08zm14.66 12.47h-3.56v-5.33c0-1.27-.02-2.9-1.77-2.9-1.78 0-2.05 1.38-2.05 2.8V20h-3.56V9h3.42v1.5h.05c.48-.9 1.66-1.85 3.42-1.85 3.66 0 4.34 2.41 4.34 5.55V20z"/>
          </svg>
        </a>
      </div>
    </div>
  </div>
</div>


<nav class="sticky top-0 z-50 bg-white border-gray-200 dark:bg-gray-900">
  <div class="max-w-screen-xl flex flex-wrap items-center justify-between mx-auto p-4">
  <a href="/" class="flex items-center space-x-3 rtl:space-x-reverse">
    <img src="/images/logo.png" class="h-8" alt="32nd IEK International Convention Logo" />
      <span class="self-center text-2xl font-semibold whitespace-nowrap dark:text-white"></span>
  </a>
  <div class="flex md:order-2 space-x-3 md:space-x-0 rtl:space-x-reverse">
      <a href="https://book.iek.events/events/RVYtMjMtMDAwMjI1" target="_blank"
        class="text-white bg-red-800 hover:bg-amber-400 hover:text-red-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-fuchsia-800 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
        REGISTER
      </a>

      <button data-collapse-toggle="navbar-cta" type="button" class="inline-flex items-center p-2 w-10 h-10 justify-center text-sm text-gray-500 rounded-lg md:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600" aria-controls="navbar-cta" aria-expanded="false">
        <span class="sr-only">Open main menu</span>
        <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 17 14">
            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M1 1h15M1 7h15M1 13h15"/>
        </svg>
    </button>
  </div>
  <div class="items-center justify-between hidden w-full md:flex md:w-auto md:order-1" id="navbar-cta">
  <ul class="flex flex-col font-medium p-4 md:p-0 mt-4 border border-gray-100 rounded-lg bg-gray-50 md:space-x-8 rtl:space-x-reverse md:flex-row md:mt-0 md:border-0 md:bg-white dark:bg-gray-800 md:dark:bg-gray-900 dark:border-gray-700">
    <li>
      <a href="<?php echo e(url('/')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
                <?php echo e(Request::is('/') ? 'text-white bg-red-800 md:bg-transparent md:text-red-800 md:dark:text-pink-200' : 'text-gray-900 hover:bg-gray-100 md:hover:bg-transparent md:hover:text-red-600 md:dark:hover:text-blue-500 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent'); ?>">
        Home
      </a>
    </li>

    <li class="md:hidden">
      <a href="<?php echo e(url('/about')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
          <?php echo e(Request::is('about*') ? 'text-white bg-red-800' : 'text-gray-900 hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white'); ?>">
        About WEC Summit
      </a>
    </li>

    <li class="md:hidden">
      <a href="<?php echo e(asset('/docs/WEC_Concept_Note.pdf')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
          <?php echo e(Request::is('#') ? 'text-white bg-red-800' : 'text-gray-900 hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white'); ?>">
        Concept Note
      </a>
    </li>

    <li class="md:hidden">
      <a href="<?php echo e(url('/guests')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
          <?php echo e(Request::is('guests') ? 'text-white bg-red-800' : 'text-gray-900 hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white'); ?>">
        Guests
      </a>
    </li>

    <li class="md:hidden">
      <a href="<?php echo e(url('/speakers')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
          <?php echo e(Request::is('speakers') ? 'text-white bg-red-800' : 'text-gray-900 hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white'); ?>">
        Speakers
      </a>
    </li>

    <li class="md:hidden">
      <a href="<?php echo e(url('/awards')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
          <?php echo e(Request::is('awards') ? 'text-white bg-red-800' : 'text-gray-900 hover:bg-gray-100 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white'); ?>">
        Award Nominations
      </a>
    </li>
    
    



    <!-- Dropdown About -->
    <li class="relative group desktop-dropdown">
    <button
      class="flex items-center justify-between w-full py-2 px-3 text-gray-900 rounded-sm hover:bg-gray-100 md:hover:bg-transparent md:border-0 md:hover:text-red-600 md:p-0 md:w-auto dark:text-white md:dark:hover:text-blue-500 dark:focus:text-white dark:border-gray-700 dark:hover:bg-gray-700 md:dark:hover:bg-transparent">
      About
      <svg class="w-2.5 h-2.5 ms-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
        viewBox="0 0 10 6">
        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
          d="m1 1 4 4 4-4" />
      </svg>
    </button>

    <!-- Dropdown menu: hidden on mobile, hover show on desktop -->
    <div
      class="absolute left-0 top-full z-10 hidden md:group-hover:block bg-white divide-y divide-gray-100 rounded-lg shadow-sm w-44 dark:bg-gray-700 dark:divide-gray-600">
      <ul class="py-2 text-sm text-gray-700 dark:text-gray-400">
      <li>
        <a href="<?php echo e(url('concept-note')); ?>"
          class="block px-4 py-2 
          <?php echo e(Request::is('concept-note') ? 'bg-red-800 text-white' : ''); ?> 
          hover:bg-amber-400 dark:hover:bg-gray-600 dark:hover:text-white">
          Concept Note
        </a>
      </li>
      <li>
        <a href="<?php echo e(asset('/docs/WEC_Concept_Note.pdf')); ?>"
          class="block px-4 py-2 
          <?php echo e(Request::is('') ? 'bg-red-800 text-white' : ''); ?> 
          hover:bg-amber-400 dark:hover:bg-gray-600 dark:hover:text-white">
          Expression of Interest
        </a>
      </li>
      <li>
        <a href="<?php echo e(asset('/docs/WEC_Concept_Note.pdf')); ?>"
          class="block px-4 py-2 
          <?php echo e(Request::is('') ? 'bg-red-800 text-white' : ''); ?> 
          hover:bg-amber-400 dark:hover:bg-gray-600 dark:hover:text-white">
          Call for Abstracts
        </a>
      </li>
             
    </div>
  </li>

  


    <li>
      <a href="<?php echo e(url('/sponsorship')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
                <?php echo e(Request::is('sponsorship') ? 'text-white bg-fuchsia-800 md:bg-transparent md:text-fuchsia-800 md:dark:text-purple-950' : 'text-gray-900 hover:bg-gray-100 md:hover:bg-transparent md:hover:text-red-500 md:dark:hover:text-blue-500 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent'); ?>">
        Sponsorship Opportunities
      </a>
    </li>

    <li>
      <a href="<?php echo e(url('/convention-accommodation')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
                <?php echo e(Request::is('convention-accommodation') ? 'text-white bg-fuchsia-800 md:bg-transparent md:text-fuchsia-800 md:dark:text-purple-950' : 'text-gray-900 hover:bg-gray-100 md:hover:bg-transparent md:hover:text-red-500 md:dark:hover:text-blue-500 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent'); ?>">
        Convention Accomodation
      </a>
    </li>

    <li>
      <a href="<?php echo e(url('/convention-accommodation')); ?>"
        class="block py-2 px-3 md:p-0 rounded-sm
                <?php echo e(Request::is('convention-accommodation') ? 'text-white bg-fuchsia-800 md:bg-transparent md:text-fuchsia-800 md:dark:text-purple-950' : 'text-gray-900 hover:bg-gray-100 md:hover:bg-transparent md:hover:text-red-500 md:dark:hover:text-blue-500 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent'); ?>">
        31st Convention Highlights
      </a>
    </li>

  </ul>

  </div>
  </div>
</nav>
<?php /**PATH C:\Users\user\Documents\projects\convention\resources\views/layouts/navigation.blade.php ENDPATH**/ ?>