<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', '32nd IEK Convention')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css">

        <!-- FlipDown CSS -->
        <link rel="stylesheet" href="https://unpkg.com/flipdown@0.3.2/dist/flipdown.min.css" />

        <!-- Link Swiper's CSS -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
            <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- Page Heading -->
            <?php if(isset($header)): ?>
                <header class="bg-white dark:bg-gray-800 shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        <?php echo e($header); ?>

                    </div>
                </header>
            <?php endif; ?>

            <!-- Page Content -->
            <main>
                <?php echo e($slot); ?>

            </main>

            <!-- Footer -->
            <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <!-- Flowbite JS for toggling hamburger menu -->
        <script src="https://unpkg.com/flowbite@2.3.0/dist/flowbite.min.js"></script>

        <!-- FlipDown JS -->
        <script src="https://unpkg.com/flipdown@0.3.2/dist/flipdown.min.js"></script>
        
        <!-- Swiper JS -->
        <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

        <!-- Initialize Swiper -->
        <script>
        var swiper = new Swiper(".mySwiper", {
            effect: "cube",
            grabCursor: true,
            speed: 2000,
            cubeEffect: {
            shadow: true,
            slideShadows: true,
            shadowOffset: 20,
            shadowScale: 0.94,
            },
            pagination: {
            el: ".swiper-pagination",
            },
            autoplay: {
                delay: 2500,
                disableOnInteraction: false
            },
        });
        </script>


        <!-- Number Counter -->
        <script>
            const counters = document.querySelectorAll('.counter');

            const animateCount = (counter) => {
            const update = () => {
                const target = +counter.getAttribute('data-target');
                const current = +counter.innerText.replace(/,/g, '');
                const increment = Math.max(1, target / 50);

                if (current < target) {
                counter.innerText = Math.ceil(current + increment).toLocaleString();
                setTimeout(update, 20);
                } else {
                counter.innerText = target.toLocaleString();
                }
            };
            update();
            };

            const observer = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                animateCount(entry.target);
                observer.unobserve(entry.target);
                }
            });
            }, { threshold: 0.6 });

            counters.forEach(counter => observer.observe(counter));
        </script>

        
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/gh/blasten/turn.js@master/turn.min.js"></script>

        <?php echo $__env->yieldPushContent('scripts'); ?> 
    </body>
</html>
<?php /**PATH C:\Users\user\Documents\projects\convention\resources\views/layouts/app.blade.php ENDPATH**/ ?>