<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<div class="bg-gray-100 dark:bg-gray-900 py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-7xl mx-auto">
        <h2 class="text-3xl font-bold text-center text-red-800 dark:text-red-400 mb-10">Travel & Accommodation</h2>

        <p class="text-center text-gray-700 dark:text-gray-300 mb-12 max-w-2xl mx-auto">
            Find your ideal stay at the Engineers Convention with a range of accommodation options. Choose from luxury hotels, business-class comfort, or budget-friendly choices to suit your preferences.
        </p>

        <div class="grid gap-6 sm:grid-cols-1 md:grid-cols-2 lg:grid-cols-3">
            <?php
                $hotels = [
                    [
                        'name' => 'Prideinn Paradise Beach Resort & Spa (Host Venue)',
                        'image' => 'prideinn-paradise.jpg',
                        'rates' => [
                            'Ksh. 16,500/= per night (BB)',
                            'Ksh. 17,000/= per night (Half Board)',
                        ],
                        'phone' => '+254 723 634 669',
                        'email' => 'dsm@prideinnparadise.com',
                    ],
                    [
                        'name' => 'Prideinn Flamingo Beach & Spa',
                        'image' => 'prideinn-flamingo.jpg',
                        'rates' => [
                            'Ksh. 16,000/= per night (Half Board)',
                            'Ksh. 15,500/= per night (BB)',
                        ],
                        'phone' => '+254 723 634 669',
                        'email' => 'dsm@prideinnflamingo.com',
                    ],
                    [
                        'name' => 'Travellers Beach Hotel and Club',
                        'image' => 'travellers-beach.jpg',
                        'rates' => [
                            'Ksh. 14,000/= per night (Half Board)',
                            'Ksh. 13,000/= per night (BB)',
                        ],
                        'phone' => '+254 720 566 626',
                        'email' => 'nambalu.evalyn@travellershtl.com',
                    ],
                    [
                        'name' => 'Sarova Whitesands Beach Hotel',
                        'image' => 'sarova-whitesands.jpg',
                        'rates' => [
                            'Ksh. 20,000/= Garden View (Half Board)',
                            'Ksh. 25,000/= Sea Front (Half Board)',
                        ],
                        'phone' => '+254 722 852 001',
                        'email' => 'vera.moraa@sarovahotels.com',
                    ],
                    [
                        'name' => 'Sunset Paradise Holiday Homes',
                        'image' => 'sunset-paradise.jpg',
                        'rates' => [
                            'Ksh. 4,850 Bed Only',
                            'Ksh. 7,100 Half Board',
                        ],
                        'phone' => '+254 727 763 812',
                        'email' => 'sunsettmarketing00@gmail.com',
                    ],
                    [
                        'name' => 'Neptune Beach Resort',
                        'image' => 'neptune-beach.jpg',
                        'rates' => [
                            'Ksh. 14,850/= Single (BB)',
                            'Ksh. 22,000/= Twin (BB)',
                        ],
                        'phone' => '+254 734 346 942',
                        'email' => 'sales2@neptunehotels.com',
                    ],
                    [
                        'name' => 'Serena Beach Resort & Spa',
                        'image' => 'serena-beach.jpg',
                        'rates' => [
                            'Ksh. 21,150/= Single (Half Board)',
                            'Ksh. 25,000/= Twin (BB)',
                        ],
                        'phone' => '+254 734 699 853',
                        'email' => 'reservations.mombasa@serenahotels.com',
                    ],
                ];
            ?>

            <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden flex flex-col">
                <!-- Hotel Image -->
                <img src="<?php echo e(asset('images/' . $hotel['image'])); ?>" alt="<?php echo e($hotel['name']); ?>" class="w-full h-48 object-cover">

                <!-- Card Body -->
                <div class="p-5 flex flex-col justify-between flex-grow">
                    <div>
                        <h3 class="text-xl font-semibold text-red-800 dark:text-red-400 mb-2"><?php echo e($hotel['name']); ?></h3>
                        <ul class="text-gray-700 dark:text-gray-300 text-sm mb-4 list-disc list-inside">
                            <?php $__currentLoopData = $hotel['rates']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($rate); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>

                <!-- Card Footer with Contact Info -->
                <div class="bg-red-100 dark:bg-gray-700 px-4 py-3 text-sm text-center text-gray-800 dark:text-gray-200">
                    <p class="flex  gap-2 mb-1">
                        <i class="fas fa-phone-alt text-red-700 dark:text-red-400"></i>
                        <a href="tel:<?php echo e($hotel['phone']); ?>" class="hover:underline"><?php echo e($hotel['phone']); ?></a>
                    </p>
                    <p class="flex gap-2">
                        <i class="fas fa-envelope text-red-700 dark:text-red-400"></i>
                        <a href="mailto:<?php echo e($hotel['email']); ?>" class="text-blue-600 dark:text-blue-300 underline break-all">
                            <?php echo e($hotel['email']); ?>

                        </a>
                    </p>
                </div>
            </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\user\Documents\projects\convention\resources\views/accommodation.blade.php ENDPATH**/ ?>